uniform sampler2D texture0;
uniform vec2 textureSize0;
varying vec4 gl_TexCoord[];



uniform float u_Elapsed;
uniform vec2 u_WindowSize;

#define iTime u_Elapsed 
#define iResolution vec2(500,500)


void main( void )
{
  
  vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
    vec2 center = vec2(0.5,0.5*(iResolution.y/iResolution.x));
    
    vec2 light1 = vec2(-sin(iTime)/5.0 ,-cos(iTime)/20.0-0.2)+center;
    vec3 lightColor1 = vec3(0.3, 0.3, 1.0);
    
    vec2 light2 = vec2(-sin(iTime)/10.0 ,cos(iTime)/30.0-0.2)+center;
    vec3 lightColor2 = vec3(0.3, 0.3, 1.0);
    
    vec2 light3 = vec2(sin(iTime)/4.0 ,sin(iTime)/25.0-0.2)+center;
    vec3 lightColor3 = vec3(0.3, 0.3, 1.0);

    
    float cloudIntensity1 = 0.7*(1.0-(2.5*distance(uv, light1)));
    float lighIntensity1 = 1.0/(50.0*distance(uv,light1));

    float cloudIntensity2 = 0.7*(1.0-(2.5*distance(uv, light2)));
    float lighIntensity2 = 1.0/(50.0*distance(uv,light2));
    
    float cloudIntensity3 = 0.7*(1.0-(2.5*distance(uv, light3)));
    float lighIntensity3 = 1.0/(50.0*distance(uv,light3));
    
    
     

 

    if (uv.y < 0.5)
    {
      gl_FragColor = vec4( lighIntensity1*lightColor1 +
                    lighIntensity2*lightColor2 +
                    lighIntensity3*lightColor3 
                    ,1.0);

      float mask = 1. - ((uv.y + 0.5) - 0.5 ) / (1. - 0.5);
      gl_FragColor.r = gl_FragColor.r * mask;
       gl_FragColor.g = gl_FragColor.g * mask;
        gl_FragColor.b = gl_FragColor.b * mask;
    }
    else
      gl_FragColor.rgba = vec4(0.);

}











